
from gurobipy import *

# Create a new model
m = Model("electronics_company_profit")

# Add variables
x1 = m.addVar(lb=0, ub=20, vtype=GRB.INTEGER, name="entry_level_devices")
x2 = m.addVar(lb=0, ub=15, vtype=GRB.INTEGER, name="premium_devices")

# Set the objective function
m.setObjective(300*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 30, "total_devices")
m.addConstr(x1 <= 20, "entry_level_demand")
m.addConstr(x2 <= 15, "premium_demand")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of entry-level devices to sell: {x1.x}")
    print(f"Number of premium devices to sell: {x2.x}")
    print(f"Total profit: ${300*x1.x + 200*x2.x}")
else:
    print("No optimal solution found")
