
import gurobipy as gp

# Create a new model
model = gp.Model("Electronics_Company_Optimization")

# Define variables
x1 = model.addVar(lb=0, ub=20, name="entry_level_devices")
x2 = model.addVar(lb=0, ub=15, name="premium_devices")

# Objective function: Maximize profit
model.setObjective(300*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 20, name="entry_level_demand")
model.addConstr(x2 <= 15, name="premium_demand")
model.addConstr(x1 + x2 <= 30, name="total_devices_sold")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Entry-level devices to sell: {x1.varValue}")
    print(f"Premium devices to sell: {x2.varValue}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
