
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("movie_theatre_optimization")

# Create variables
regular_passes = m.addVar(vtype=GRB.INTEGER, name="regular_passes")
premium_passes = m.addVar(vtype=GRB.INTEGER, name="premium_passes")

# Set objective function
m.setObjective(40 * regular_passes + 90 * premium_passes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(regular_passes + premium_passes <= 500, "total_passes")
m.addConstr(premium_passes >= 100, "min_premium")
m.addConstr(regular_passes >= 3 * premium_passes, "regular_premium_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of regular passes: {regular_passes.x}")
    print(f"Number of premium passes: {premium_passes.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

