
from gurobipy import *

# Create a new model
m = Model("Movie_Theatre_Optimization")

# Define variables
x1 = m.addVar(name="regular_passes", lb=0)
x2 = m.addVar(name="premium_passes", lb=0)

# Set the objective function
m.setObjective(40*x1 + 90*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 500, name="total_passes_limit")
m.addConstr(x2 >= 100, name="premium_passes_minimum")
m.addConstr(x1 >= 3*x2, name="regular_vs_premium_ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal}")
    print(f"Number of regular passes: {x1.x}")
    print(f"Number of premium passes: {x2.x}")
else:
    print("No optimal solution found")
