
import gurobi

def solve_movie_theatre_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="regular_passes", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="premium_passes", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: maximize 40*x1 + 90*x2
    model.setObjective(40*x1 + 90*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 500, name="total_passes")
    model.addConstr(x2 >= 100, name="premium_passes_min")
    model.addConstr(x1 >= 3*x2, name="regular_to_premium_ratio")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: regular passes = {x1.varValue}, premium passes = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_movie_theatre_problem()
