
import gurobipy as gp

# Create a new model
model = gp.Model("Car Production")

# Create variables
race_cars = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="race_cars")
regular_cars = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="regular_cars")


# Set objective function
model.setObjective(20000 * race_cars + 10000 * regular_cars, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(race_cars <= 3, "race_car_limit")
model.addConstr(regular_cars <= 5, "regular_car_limit")
model.addConstr(race_cars + regular_cars <= 6, "safety_check_limit")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Number of race cars to produce: {race_cars.x}")
    print(f"Number of regular cars to produce: {regular_cars.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

