
from gurobipy import *

# Create a new model
m = Model("car_production")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="race_cars", lb=0)
x2 = m.addVar(vtype=GRB.INTEGER, name="regular_cars", lb=0)

# Set objective function
m.setObjective(20000*x1 + 10000*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 3, "race_car_production_limit")
m.addConstr(x2 <= 5, "regular_car_production_limit")
m.addConstr(x1 + x2 <= 6, "safety_check_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of race cars: {x1.x}")
    print(f"Number of regular cars: {x2.x}")
    print(f"Total profit: ${20000*x1.x + 10000*x2.x}")
else:
    print("No optimal solution found")
