
import gurobipy as gp

# Create a new model
model = gp.Model("Car_Production")

# Define variables
x1 = model.addVar(name="race_cars", lb=0, ub=3, vtype=gp.GRB.INTEGER)  # Number of race cars
x2 = model.addVar(name="regular_cars", lb=0, ub=5, vtype=gp.GRB.INTEGER)  # Number of regular cars

# Objective function: Maximize profit
model.setObjective(20000*x1 + 10000*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 3, name="race_car_limit")
model.addConstr(x2 <= 5, name="regular_car_limit")
model.addConstr(x1 + x2 <= 6, name="safety_check_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {model.getVarByName('race_cars').varValue} race cars, {model.getVarByName('regular_cars').varValue} regular cars")
    print(f"Maximum profit: ${model.objVal}")
else:
    print("No optimal solution found")
