
import gurobipy as gp

# Create a new model
model = gp.Model("Kald_Vehicle_Production")

# Create decision variables
minivans = model.addVar(vtype=gp.GRB.CONTINUOUS, name="minivans")  # Number of minivans
trucks = model.addVar(vtype=gp.GRB.CONTINUOUS, name="trucks")  # Number of trucks


# Set objective function: Maximize profit
model.setObjective(1200 * minivans + 1700 * trucks, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * minivans + 4 * trucks <= 12, "assembly_constraint")  # Assembly machine constraint
model.addConstr(1.5 * minivans + 2 * trucks <= 11, "painting_constraint")  # Painting machine constraint
model.addConstr(minivans >= 0, "minivan_nonnegativity") # Non-negativity constraint for minivans
model.addConstr(trucks >= 0, "truck_nonnegativity") # Non-negativity constraint for trucks


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Minivans to produce: {minivans.x}")
    print(f"Number of Trucks to produce: {trucks.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

