
from gurobipy import *

# Create a new model
m = Model("Vehicle_Production")

# Define variables
x1 = m.addVar(name="minivans", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="trucks", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(1200*x1 + 1700*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 <= 12, name="assembly_machine")
m.addConstr(1.5*x1 + 2*x2 <= 11, name="painting_machine")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Minivans: {x1.x}")
    print(f"Trucks: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
