
import gurobi

def solve_vehicle_production():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="minivans", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="trucks", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(1200 * x1 + 1700 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2 * x1 + 4 * x2 <= 12, name="assembly_machine")
    model.addConstr(1.5 * x1 + 2 * x2 <= 11, name="painting_machine")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Minivans: {x1.varValue}")
        print(f"Trucks: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_vehicle_production()
