
import gurobipy as gp

# Create a new model
m = gp.Model("watch_production")

# Create variables
digital = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="digital")
analog = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="analog")


# Set objective function
m.setObjective(15 * digital + 10 * analog, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(digital >= 150, "digital_demand")
m.addConstr(analog >= 120, "analog_demand")
m.addConstr(digital <= 200, "digital_capacity")
m.addConstr(analog <= 180, "analog_capacity")
m.addConstr(digital + analog >= 300, "total_shipment")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of digital watches to produce: {digital.x}")
    print(f"Number of analog watches to produce: {analog.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

