
import gurobi

def solve_watch_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="digital_watches")
    x2 = model.addVar(lb=0, name="analog_watches")

    # Set bounds according to the constraints
    x1.lb = 150
    x2.lb = 120
    x1.ub = 200
    x2.ub = 180

    # Objective function
    model.setObjective(15 * x1 + 10 * x2, gurobi.GRB.MAXIMIZE)

    # Additional constraints
    model.addConstr(x1 + x2 >= 300, name="total_watches")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Digital watches: {x1.varValue}")
        print(f"Analog watches: {x2.varValue}")
        print(f"Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_watch_problem()
