
import gurobipy as gp

# Create a new model
model = gp.Model("BakeryOptimization")

# Create decision variables
pancakes = model.addVar(vtype=gp.GRB.CONTINUOUS, name="pancakes")
pretzels = model.addVar(vtype=gp.GRB.CONTINUOUS, name="pretzels")

# Set objective function
model.setObjective(25 * pancakes + 50 * pretzels, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2.5 * pancakes + 1.5 * pretzels <= 65, "oven_time")
model.addConstr(0.5 * pancakes + 3 * pretzels <= 35, "pastry_chef_time")
model.addConstr(pancakes >= 0, "pancakes_nonnegative")
model.addConstr(pretzels >= 0, "pretzels_nonnegative")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Batches of pancakes: {pancakes.x}")
    print(f"Batches of pretzels: {pretzels.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

