
from gurobipy import *

# Create a new model
m = Model("Tom_Bakery")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="pancakes", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="pretzels", lb=0)

# Set the objective function
m.setObjective(25*x1 + 50*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*x1 + 1.5*x2 <= 65, "oven_time")
m.addConstr(0.5*x1 + 3*x2 <= 35, "pastry_chef_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of batches of pancakes: {x1.x}")
    print(f"Number of batches of pretzels: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
