
import gurobi

def solve_bakery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="pancakes")
    x2 = model.addVar(lb=0, name="pretzels")

    # Define the objective function
    model.setObjective(25*x1 + 50*x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(2.5*x1 + 1.5*x2 <= 65, name="oven_constraint")
    model.addConstr(0.5*x1 + 3*x2 <= 35, name="pastry_chef_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Pancakes: {x1.varValue}")
        print(f"Pretzels: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_bakery_problem()
