
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("instrument_store")

# Create variables
pianos = m.addVar(vtype=GRB.INTEGER, name="pianos")
guitars = m.addVar(vtype=GRB.INTEGER, name="guitars")

# Set objective function
m.setObjective(300 * pianos + 200 * guitars, GRB.MAXIMIZE)

# Add constraints
m.addConstr(8 * pianos + 3 * guitars <= 100, "space_constraint")
m.addConstr(500 * pianos + 300 * guitars <= 8000, "budget_constraint")
m.addConstr(guitars >= 0.3 * (pianos + guitars), "guitar_ratio_constraint")
m.addConstr(pianos >= 0, "pianos_nonnegative")
m.addConstr(guitars >= 0, "guitars_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of pianos: {pianos.x}")
    print(f"Number of guitars: {guitars.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

