
import gurobipy as gp

# Create a new model
model = gp.Model("Instrument_Store_Optimization")

# Define the variables
x1 = model.addVar(name="pianos", vtype=gp.GRB.INTEGER, lb=0)  # Number of pianos
x2 = model.addVar(name="guitars", vtype=gp.GRB.INTEGER, lb=0)  # Number of guitars

# Objective function: Maximize profit
model.setObjective(300*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Space constraint
model.addConstr(8*x1 + 3*x2 <= 100, name="space_constraint")

# Budget constraint
model.addConstr(500*x1 + 300*x2 <= 8000, name="budget_constraint")

# Guitar percentage constraint
model.addConstr(x2 >= 0.3*(x1 + x2), name="guitar_percentage_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of pianos: {x1.varValue}")
    print(f"Optimal number of guitars: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("The model is infeasible.")
