
import gurobipy as gp

# Create a new model
m = gp.Model("PopcornMix")

# Create variables
family_mix = m.addVar(name="family_mix")  # x1: pounds of family mix
party_mix = m.addVar(name="party_mix")  # x2: pounds of party mix


# Set objective function: Maximize profit
m.setObjective(4.5 * family_mix + 6 * party_mix, gp.GRB.MAXIMIZE)

# Add constraints:
# Butter popcorn constraint
m.addConstr(0.5 * family_mix + 0.2 * party_mix <= 35, "butter_popcorn")

# Caramel popcorn constraint
m.addConstr(0.5 * family_mix + 0.8 * party_mix <= 45, "caramel_popcorn")

# Non-negativity constraints
m.addConstr(family_mix >= 0, "family_mix_nonneg")
m.addConstr(party_mix >= 0, "party_mix_nonneg")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Family mix: {family_mix.x:.2f} pounds")
    print(f"Party mix: {party_mix.x:.2f} pounds")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

