
import gurobi

def solve_popcorn_problem():
    # Create a new model
    m = gurobi.Model()

    # Define variables
    x1 = m.addVar(name="family_mix", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = m.addVar(name="party_mix", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    m.setObjective(4.5 * x1 + 6 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    m.addConstr(0.5 * x1 + 0.2 * x2 <= 35, name="butter_constraint")
    m.addConstr(0.5 * x1 + 0.8 * x2 <= 45, name="caramel_constraint")

    # Optimize
    m.optimize()

    # Print solution
    if m.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Family mix: {x1.varValue} bags")
        print(f"Party mix: {x2.varValue} bags")
        print(f"Max profit: {m.objVal}")
    else:
        print("No optimal solution found")

solve_popcorn_problem()
