
import gurobipy as gp

# Create a new model
m = gp.Model("Gary's Diet")

# Create variables
noodles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="noodles") # Servings of noodles
cakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cakes") # Servings of cakes


# Set objective function
m.setObjective(3 * noodles + 5 * cakes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * noodles + 4 * cakes <= 100, "Protein Constraint")
m.addConstr(12 * noodles + 8 * cakes <= 30, "Mineral Constraint")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Servings of Noodles: {noodles.x}")
    print(f"Servings of Cakes: {cakes.x}")
    print(f"Minimum Cost: ${m.objVal}")

