
from gurobipy import *

# Create a new model
m = Model("Gary's Diet")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="servings_of_noodles")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="servings_of_cakes")

# Define the objective function
m.setObjective(3*x1 + 5*x2, GRB.MINIMIZE)

# Add the constraints
m.addConstr(5*x1 + 4*x2 <= 100, "protein_constraint")
m.addConstr(12*x1 + 8*x2 <= 30, "mineral_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Servings of noodles:", x1.x)
    print("Servings of cakes:", x2.x)
    print("Total cost:", m.objVal)
else:
    print("No optimal solution found")
