
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="noodles")
    x2 = model.addVar(lb=0, name="cakes")

    # Define the objective function
    model.setObjective(3*x1 + 5*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(5*x1 + 4*x2 <= 100, name="protein_constraint")
    model.addConstr(12*x1 + 8*x2 <= 30, name="mineral_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Servings of noodles: {x1.varValue}")
        print(f"Servings of cakes: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
