
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
housing = m.addVar(name="housing")
roads = m.addVar(name="roads")

# Set objective function
m.setObjective(0.95 * housing + 0.32 * roads, GRB.MAXIMIZE)

# Add constraints
m.addConstr(housing + roads <= 3500, "budget_constraint")
m.addConstr(housing >= 750, "housing_min")
m.addConstr(roads >= 0.24 * (housing + roads), "roads_min_percent")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Objective value: {m.objVal}")
    print(f"Invest ${housing.x:.2f} in housing")
    print(f"Invest ${roads.x:.2f} in roads")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

