
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(name="housing", lb=0)
x2 = m.addVar(name="roads", lb=0)

# Set the objective function
m.setObjective(0.95*x1 + 0.32*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 3500, name="budget")
m.addConstr(x1 >= 750, name="min_housing")
m.addConstr(x2 >= 0.24*(x1 + x2), name="min_roads")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Housing: {x1.x}")
    print(f"Roads: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
