
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Problem")

# Define the variables
x1 = model.addVar(name="housing", lb=0)  # Investment in housing
x2 = model.addVar(name="roads", lb=0)     # Investment in roads

# Objective function: Maximize 0.95*x1 + 0.32*x2
model.setObjective(0.95*x1 + 0.32*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 3500, name="budget_constraint")
model.addConstr(x1 >= 750, name="housing_min_constraint")
model.addConstr(x2 >= (6/19)*x1, name="roads_min_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Investment in housing: ${x1.varValue:.2f}")
    print(f"Investment in roads: ${x2.varValue:.2f}")
    print(f"Total Profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
