
import gurobipy as gp

# Create a new model
m = gp.Model("TrainAcrossCanada")

# Create variables
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="sleeper_class")
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="regular_tickets")


# Set objective function
m.setObjective(500*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 400, "Total_passengers")
m.addConstr(x2 <= 5*x1, "Regular_preference")
m.addConstr(x1 >= 50, "Min_sleeper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Maximum profit: ${m.objVal}")
    print(f"Number of sleeper class tickets: {x1.x}")
    print(f"Number of regular tickets: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

