
from gurobipy import *

# Create a new model
m = Model("TrainAcrossCanada")

# Define variables
x1 = m.addVar(name='sleeper_class_tickets', vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name='regular_tickets', vtype=GRB.INTEGER, lb=0)

# Set objective function
m.setObjective(500*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 400, name='total_passengers')
m.addConstr(x2 >= 5*x1, name='regular_vs_sleeper')
m.addConstr(x1 >= 50, name='min_sleeper_class')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Maximum profit: {m.objVal}")
    print(f"Sleeper class tickets to sell: {x1.x}")
    print(f"Regular tickets to sell: {x2.x}")
else:
    print("No optimal solution found.")
