
import gurobi

def train_across_canada():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="sleeper_class", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="regular_class", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(500 * x1 + 200 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 400, name="total_passengers")
    model.addConstr(x2 >= 5 * x1, name="regular_to_sleeper_ratio")
    model.addConstr(x1 >= 50, name="sleeper_class_min")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${500*x1.varValue + 200*x2.varValue}")
    else:
        print("No optimal solution found")

train_across_canada()
