
import gurobipy as gp

# Create a new model
m = gp.Model("Wine_Promotion")

# Create decision variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # number of package A
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # number of package B


# Set objective function
m.setObjective(120*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 2*x2 <= 1000, "Red_Wine_Constraint")
m.addConstr(1*x1 + 3*x2 <= 800, "White_Wine_Constraint")
m.addConstr(x1 >= 0, "NonNegativity_x1")
m.addConstr(x2 >= 0, "NonNegativity_x2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found. Maximum Profit: ${m.objVal}")
    print(f"Number of Package A: {x1.x}")
    print(f"Number of Package B: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

