
from gurobipy import *

# Create a new model
m = Model("Wine_Promotions")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Package_A")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Package_B")

# Set the objective function
m.setObjective(120*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 2*x2 <= 1000, "Red_Wine_Constraint")
m.addConstr(x1 + 3*x2 <= 800, "White_Wine_Constraint")
m.addConstr(x1 >= 0, "Non_Negativity_x1")
m.addConstr(x2 >= 0, "Non_Negativity_x2")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Package A: {x1.x}")
    print(f"Package B: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
