
import gurobipy as gp

# Create a new model
model = gp.Model("Wine Promotion")

# Define variables
x1 = model.addVar(name="Package_A", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="Package_B", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: maximize profit
model.setObjective(120*x1 + 200*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(2*x1 + 2*x2 <= 1000, name="Red_Wine_Constraint")
model.addConstr(x1 + 3*x2 <= 800, name="White_Wine_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Package A: {x1.varValue}")
    print(f"Package B: {x2.varValue}")
    print(f"Maximum Profit: {model.objVal}")
else:
    print("No optimal solution found.")
