
import gurobipy as gp

# Create a new model
model = gp.Model("wood_factory")

# Create variables
lumbers = model.addVar(vtype=gp.GRB.CONTINUOUS, name="lumbers")
plywood = model.addVar(vtype=gp.GRB.CONTINUOUS, name="plywood")


# Set objective function
model.setObjective(10 * lumbers + 35 * plywood, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * lumbers + 2 * plywood <= 2500, "worker_hours")
model.addConstr(8 * lumbers + 12 * plywood <= 4000, "machine_hours")
model.addConstr(lumbers >= 200, "min_lumbers")
model.addConstr(plywood >= 300, "min_plywood")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Number of lumbers: {lumbers.x}")
    print(f"Number of plywood: {plywood.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

