
from gurobipy import *

# Create a new model
m = Model("Wood_Factory_Optimization")

# Define variables
x1 = m.addVar(name="lumbers", vtype=GRB.INTEGER)
x2 = m.addVar(name="plywood", vtype=GRB.INTEGER)

# Set objective function
m.setObjective(10*x1 + 35*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 2500, name="worker_hours")
m.addConstr(8*x1 + 12*x2 <= 4000, name="machine_hours")
m.addConstr(x1 >= 200, name="min_lumbers")
m.addConstr(x2 >= 300, name="min_plywood")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lumbers: {x1.x}")
    print(f"Plywood: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
