
import gurobipy as gp

# Create a new model
model = gp.Model("WoodFactory")

# Define the variables
x1 = model.addVar(name="lumbers", lb=200)  # At least 200 lumbers
x2 = model.addVar(name="plywood", lb=300)  # At least 300 plywood

# Define the objective function
model.setObjective(10*x1 + 35*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x1 + 2*x2 <= 2500, name="worker_hours")
model.addConstr(8*x1 + 12*x2 <= 4000, name="machine_hours")

# Solve the model
model.solve()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: lumbers = {x1.varValue}, plywood = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
