
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("cruise_ship_profit")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="long_term_tickets") # number of long-term tickets
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="week_long_tickets") # number of week-long tickets


# Set objective function
m.setObjective(500*x1 + 150*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 1500, "capacity")
m.addConstr(x1 >= 35, "min_long_term")
m.addConstr(x2 >= 4*x1, "week_long_preference")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
    m.computeIIS()  # Compute Irreducible Inconsistent Subsystem
    m.write("model.ilp") # Write the model to a file
    print("IIS written to model.ilp")

elif m.status == GRB.OPTIMAL:

    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of long-term tickets: {x1.x}")
    print(f"Number of week-long tickets: {x2.x}")

else:
    print(f"Optimization terminated with status {m.status}")

