
from gurobipy import *

# Create a new model
m = Model("Cruise_Tickets")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="long_term_tickets")
x2 = m.addVar(vtype=GRB.INTEGER, name="week_long_tickets")

# Set the objective function
m.setObjective(500*x1 + 150*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 1500, "total_people")
m.addConstr(x1 >= 35, "min_long_term")
m.addConstr(x2 >= 4*x1, "week_long_preference")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Long-term tickets: {x1.x}")
    print(f"Week-long tickets: {x2.x}")
    print(f"Maximum profit: ${500*x1.x + 150*x2.x}")
else:
    print("No optimal solution found")
