
import gurobi

def solve_cruise_ship_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='long_term_tickets', lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='week_long_tickets', lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 500*x1 + 150*x2
    model.setObjective(500*x1 + 150*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 1500, name='capacity_constraint')
    model.addConstr(x1 >= 35, name='min_long_term_constraint')
    model.addConstr(x2 >= 4*x1, name='week_long_vs_long_term_constraint')
    model.addConstr(x1 >= 35, name='min_long_term_constraint_explicit')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Long-term tickets: {x1.varValue}, Week-long tickets: {x2.varValue}")
    else:
        print("No optimal solution found.")

solve_cruise_ship_problem()
