
import gurobipy as gp

# Create a new model
m = gp.Model("farm_investment")

# Create variables
bob_investment = m.addVar(name="bob_investment")
joe_investment = m.addVar(name="joe_investment")

# Set objective function
m.setObjective(0.08 * bob_investment + 0.06 * joe_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(bob_investment + joe_investment <= 50000, "total_investment")
m.addConstr(bob_investment >= 3 * joe_investment, "bob_min_investment")
m.addConstr(bob_investment <= 40000, "bob_max_investment")
m.addConstr(bob_investment >=0)
m.addConstr(joe_investment >=0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in Bob's farm: ${bob_investment.x:.2f}")
    print(f"Optimal investment in Joe's farm: ${joe_investment.x:.2f}")
    print(f"Maximum earnings: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

