
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Bob_Farm", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Joe_Farm", lb=0)

# Set the objective function
m.setObjective(0.08*x1 + 0.06*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 50000, "Total_Investment")
m.addConstr(x1 >= 3*x2, "Bob_VS_Joe")
m.addConstr(x1 <= 40000, "Max_Bob")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount to invest in Bob's farm: ${x1.x:.2f}")
    print(f"Amount to invest in Joe's farm: ${x2.x:.2f}")
    print(f"Total earnings: ${(0.08*x1.x + 0.06*x2.x):.2f}")
else:
    print("No optimal solution found.")
