
import gurobipy as gp

# Create a new model
model = gp.Model("Farm_Investment")

# Define the variables
x1 = model.addVar(name="Bob's_farm_investment", lb=0)
x2 = model.addVar(name="Joe's_farm_investment", lb=0)

# Objective function: maximize 0.08*x1 + 0.06*x2
model.setObjective(0.08*x1 + 0.06*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 + x2 <= 50000, name="Total_investment")
model.addConstr(x1 >= 3*x2, name="Bob_to_Joe_ratio")
model.addConstr(x1 <= 40000, name="Bob_investment_limit")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal investment in Bob's farm: $", x1.varValue)
    print("Optimal investment in Joe's farm: $", x2.varValue)
    print("Maximized earnings: $", 0.08*x1.varValue + 0.06*x2.varValue)
else:
    print("The model is infeasible")
