
import gurobipy as gp

# Create a new model
m = gp.Model("dog_food")

# Create variables
x1 = m.addVar(lb=0, name="Type_A") # kg of Type A food
x2 = m.addVar(lb=0, name="Type_B") # kg of Type B food

# Set objective function
m.setObjective(2*x1 + 5*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + 3*x2 >= 12, "meat_req")
m.addConstr(2*x1 + x2 >= 8, "micronutrient_req")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Buy {x1.x} kg of Type A food")
    print(f"Buy {x2.x} kg of Type B food")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

