
from gurobipy import *

# Create a new model
m = Model("Dog_Food_Optimization")

# Define variables
x1 = m.addVar(name="Type_A", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Type_B", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(2*x1 + 5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + 3*x2 >= 12, name="Meat_Requirement")
m.addConstr(2*x1 + x2 >= 8, name="Micronutrients_Requirement")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Type A dog food: {x1.x} kg")
    print(f"Type B dog food: {x2.x} kg")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found.")
