
import gurobi

def solve_dog_food_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="Type_A_food", lb=0, ub=float('inf'))
    x2 = model.addVar(name="Type_B_food", lb=0, ub=float('inf'))

    # Define the objective function
    model.setObjective(2*x1 + 5*x2, gurobi.MINIMIZE)

    # Define the constraints
    model.addConstr(x1 + 3*x2 >= 12, name="meat_constraint")
    model.addConstr(2*x1 + x2 >= 8, name="micronutrients_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_dog_food_problem()
