
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Tool_Manufacturing")

# Create decision variables
drills = model.addVar(vtype=GRB.CONTINUOUS, name="drills")  # Packages of drills
saws = model.addVar(vtype=GRB.CONTINUOUS, name="saws")  # Packages of saws


# Set objective function
model.setObjective(35 * drills + 100 * saws, GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * drills + 30 * saws <= 800, "Milling_Constraint")
model.addConstr(70 * drills + 90 * saws <= 800, "CNG_Constraint")
model.addConstr(drills >= 0)
model.addConstr(saws >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found. Maximum Profit: ${model.objVal:.2f}")
    print(f"Number of Drill Packages: {drills.x:.2f}")
    print(f"Number of Saw Packages: {saws.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

