
from gurobipy import *

# Create a new model
m = Model("Tool_Production")

# Define the variables
x1 = m.addVar(name="drills", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="saws", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(35*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 30*x2 <= 800, name="milling_machine")
m.addConstr(70*x1 + 90*x2 <= 800, name="CNG_machine")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Produced drills: {x1.x}")
    print(f"Produced saws: {x2.x}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
