
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="drills", lb=0)
    x2 = model.addVar(name="saws", lb=0)

    # Define the objective function
    model.setObjective(35 * x1 + 100 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(20 * x1 + 30 * x2 <= 800, name="milling_machine")
    model.addConstr(70 * x1 + 90 * x2 <= 800, name="CNG_machine")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of drills: {x1.varValue}")
        print(f"Number of saws: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
