
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
energy = m.addVar(lb=0, name="energy")
telecom = m.addVar(lb=0, name="telecom")
utilities = m.addVar(lb=0, name="utilities")
health_care = m.addVar(lb=0, name="health_care")


# Set objective function
m.setObjective(0.05 * energy + 0.08 * telecom + 0.03 * utilities + 0.09 * health_care, GRB.MAXIMIZE)

# Add constraints
m.addConstr(energy + telecom + utilities + health_care <= 300000, "Total_Investment")
m.addConstr(health_care <= energy, "Health_Care_Energy")
m.addConstr(telecom <= utilities, "Telecom_Utilities")
m.addConstr(health_care <= 0.33 * 300000, "Health_Care_Limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Invest ${energy.x:.2f} in energy")
    print(f"Invest ${telecom.x:.2f} in telecom")
    print(f"Invest ${utilities.x:.2f} in utilities")
    print(f"Invest ${health_care.x:.2f} in health care")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

