
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(name="energy", lb=0)
x2 = m.addVar(name="telecom", lb=0)
x3 = m.addVar(name="utilities", lb=0)
x4 = m.addVar(name="health_care", lb=0)

# Set the objective function
m.setObjective(0.05*x1 + 0.08*x2 + 0.03*x3 + 0.09*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 + x4 <= 300000, name="total_investment")
m.addConstr(x4 <= x1, name="health_care_vs_energy")
m.addConstr(x2 <= x3, name="telecom_vs_utilities")
m.addConstr(x4 <= 0.33 * 300000, name="max_health_care")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective Function Value: {m.objVal}")
