
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="energy", lb=0)
    x2 = model.addVar(name="telecom", lb=0)
    x3 = model.addVar(name="utilities", lb=0)
    x4 = model.addVar(name="health_care", lb=0)

    # Objective function
    model.setObjective(0.05 * x1 + 0.08 * x2 + 0.03 * x3 + 0.09 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 + x3 + x4 <= 300000)
    model.addConstr(x1 - x4 >= 0)
    model.addConstr(x3 - x2 >= 0)
    model.addConstr(x4 <= 99000)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Energy: ${x1.varValue:.2f}")
        print(f"Telecom: ${x2.varValue:.2f}")
        print(f"Utilities: ${x3.varValue:.2f}")
        print(f"Health Care: ${x4.varValue:.2f}")
        print(f"Max Return: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
